/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.betterui;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class ServerEula {
    private final Path file;
    private final boolean agreed;

    public ServerEula(Path p_i50746_1_) {
        this.file = p_i50746_1_;
        this.agreed = this.readFile();
    }

    private boolean readFile() {
        boolean bl;
        block8: {
            InputStream inputstream = Files.newInputStream(this.file, new OpenOption[0]);
            try {
                Properties properties = new Properties();
                properties.load(inputstream);
                bl = Boolean.parseBoolean(properties.getProperty("eula", "false"));
                if (inputstream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    this.saveDefaults();
                    return false;
                }
            }
            inputstream.close();
        }
        return bl;
    }

    public boolean hasAgreedToEULA() {
        return this.agreed;
    }

    private void saveDefaults() {
        try (OutputStream outputstream = Files.newOutputStream(this.file, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.setProperty("eula", "false");
            properties.store(outputstream, "By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).");
        }
        catch (Exception exception) {
            System.err.println("Could not save " + this.file + ": " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

